/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* Subject : SD502 Counter Լ   
/* Contents:  α׷ ڰ ϴ channel mode ׸
/*      source clock counter    ä īƮ
/*      о ȭ鿡 ǥմϴ. 
/* - Remarks : 
/*     1.   COMI-SD502 忡 밡մϴ.
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD502

void main (void)
{
	HANDLE hDevice;
	int channel, mode, clk_src;
	ULONG now_count, old_count;
	double clk_freq, freq;
	char resp;
	// Load DLL //
	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}
	// Load Device //
	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}
	// Get channel number //
	printf("Input Channel Number : ");
	scanf("%d", &channel);
	// Get counter mode //
	printf("Select Counter Mode (0 or 1) : ");
	scanf("%d", &mode);
	// Get source clock (only if counter mode is 0) //
	if(mode == 0){
		printf("Select Source Clock (-1 ~ 15) : ");
		scanf("%d", &clk_src);
	}
	// Set counter channel //
	COMI_SD502_SetCounter(hDevice, channel, mode, clk_src);
	COMI_SD502_Clear(hDevice, channel);
	while(1)
	{
		now_count = COMI_SD502_ReadNowCount(hDevice, channel); // Read now count
		old_count = COMI_SD502_ReadOldCount(hDevice, channel); // Read old count
		printf("\n");
		printf("Now Count = %lu\n", now_count);
		printf("Old Count = %lu\n", old_count);
		if(mode==0 && clk_src >= 0){// Display frequency of GATE signal
			clk_freq = COMI_SD502_GetClkFreq(clk_src);
			if(old_count == 0)
				freq = 0.;
			else
				freq = 0.5 * clk_freq/old_count;
			printf("Freq (Hz) = %.1f\n", freq);
		}
		printf("\nPress ESC key to exit or press any other key to continue!\n");
		resp = _getch();
		if(resp == 27) // ESC Key  
			break;
	}

	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
